@echo off
rem OpenSmedgeFirewall.bat
rem
rem Opens the appropriate ports in Windows Firewall for all Smedge component applications
rem
rem Smedge 3
rem Copyright Uberware. All Rights Reserved


rem setup
setlocal
set _MODE=add
set _PATH=%~dp0..
set _NAME=%~n0

:parse
rem detect command line
if "%1" == "" goto validate
if "%1" == "add" goto add
if "%1" == "delete" goto delete
if "%1" == "remove" goto delete
if not exist "%~1" goto missing
set _PATH=%~1
shift
goto parse

:add
set _MODE=add
shift
goto parse

:delete
set _MODE=delete
shift
goto parse

:missing
echo Error: installation folder does not exist:
echo %~1
goto usage

:validate
rem only checks for SmedgeGui.exe
if exist "%_PATH%\SmedgeGui.exe" goto go
echo Error: There is not a valid Smedge installation in the path:
echo %_PATH%
goto usage

:usage
echo.
echo Usage: %_NAME% [add^|delete] [install-path]
echo        If neither add nor delete is supplied, add is assumed
echo        If no install-path is given, it uses the script parent folder
pause
exit /b 1

:go
echo Smedge Firewall Control
for %%f in ( %_PATH%\*.exe ) do (
	echo ... %_MODE% %%~nf
	if "%_MODE%" == "add" (
		netsh advfirewall firewall add rule name="%%~nf" dir=in action=allow program="%%f" enable=yes
	) else (
		netsh advfirewall firewall delete rule name="%%~nf"
	)
)

echo Finished.
