@echo off
rem InstallService.bat
rem
rem Installs Smedge Service components on the local machine
rem
rem Smedge 3
rem Copyright Uberware. All Rights Reserved


rem NOTE: This script is meant to be run by a system administrator. 
rem NOTE: It does not check that the current running use has administrative privileges.
rem NOTE: Use by a non-administrator will lead to failure and inconsistent behavior


rem Initialize the variables we use
set _DIR=%~dp0
set _RESULT=
:exit_initialize
if [%_RESULT%] == [] (
	set _RESULT=initialize
	goto :cleanup
)


:parse
rem Parse the command line

if "%~1" == "-h"		goto :usage
if "%~1" == "-help"		goto :usage
if "%~1" == "-exe"		goto :get_exe
if "%~1" == "-user"		goto :get_user
if NOT "%~1" == ""		goto :get_extra
goto :validate

:get_exe
rem Get the executable from the command line
shift
set _EXE=%~1
shift
goto :parse

:get_user
rem Get the user account and password to use
shift
set _USER=%~1
shift
set _PASS=%1
shift
goto :parse

:get_extra
rem The rest are passed on to daemon command line parameters
set _EXTRA=%_EXTRA% "%1"
shift
goto :parse


:validate
rem Validate the operation


echo ++ Validating Service installation request ++

rem Validate the configuration
if "%_COMPONENT%" == "" goto :adv_usage
if "%_DISPLAY%"   == "" goto :adv_usage
if "%_MESSAGE%"   == "" goto :adv_usage
echo      Component: %_DISPLAY% (%_COMPONENT%)

rem Validate the script location
if [%_EXE%] == [] set _EXE=%_DIR%..\%_COMPONENT%.exe
echo      Checking for executable: %_EXE%
echo.
if not exist "%_EXE%" goto :corrupt

rem Validate the user account
if [%_USER%] == [] (
	call "%_DIR%CreateSmedgeUser.bat"
	set _USER=Smedge
	set _PASS=Smedge
)
rem Make sure it has a domain. Use .\ if none is supplied
if [%_USER:*\=%] == [%_USER%] set _USER=.\%_USER%


echo ++ Installing %_COMPONENT% as a Service ++
echo      User Account: %_USER%
echo      Other params: %_EXTRA%
echo.


rem Stop and remove the current service if needed

echo ... Removing old service
call "%_DIR%RemoveService.bat" %_COMPONENT%


rem Give the new account the Service Logon Right

echo ... Granting "%_USER:*\=%" permission to start services
"%_DIR%ntrights" -u "%_USER:*\=%" +r SeServiceLogonRight 1>nul 2>nul
if %ERRORLEVEL% NEQ 0 (
	echo Warning: Could not grant "Log on as a service" right to user %_USER%.
	echo The Service may not start. Check the user account name and password.
	echo.
)


rem Install the new service

rem create the service
echo ... Installing new service
set _S_OP=install
set _LOG="%TEMP%\_Install_%_COMPONENT%.log"
sc create %_COMPONENT% start= auto DisplayName= "%_DISPLAY%" obj= "%_USER%" password= "%_PASS%" binPath= "\"%_EXE%\" -daemon %_EXTRA%" 1>%_LOG% 2>&1
if %ERRORLEVEL% NEQ 0 goto :failed
del %_LOG%

rem Set the service description
sc description %_COMPONENT% "%_MESSAGE%" 1>nul 2>nul

rem Set the service to automatically restart if it crashes
sc failure %_COMPONENT% reset= 0 actions= restart/0 1>nul 2>nul


rem Try to start the service

echo ... Starting the service
set _S_OP=start
net start %_COMPONENT% 1>%_LOG% 2>&1
if %ERRORLEVEL% NEQ 0 goto :failed
del %_LOG%


rem done!

set _RESULT=0
goto :cleanup


:cleanup

rem cleanup
if NOT %_RESULT% == initialize set _DIR=
set   _EXE=
set   _LOG=
set  _USER=
set  _PASS=
set _EXTRA=
goto :exit_%_RESULT%


:usage

echo Usage:
echo InstallService [parameter] ...
echo.
echo -h/-help                  Shows this message
echo -exe ^<path^>               Sets the path to the executable to install 
echo -user ^<user^> ^<password^>   Sets the user account and password
echo.
echo All other parameters are added to the service command line.
echo.
echo If you do not supply an executable, the script will look for the executable
echo up one directory from the directory in which the script resides.
echo.
echo If no user account is supplied, this script will call the CreateSmedgeUser
echo script to create a user account on the local machine. The username and
echo password will both be "Smedge" (without quotes). The account will be an
echo Administrator account in order to allow the Engine to remap network drives
echo if needed.
echo.
echo If you do supply a user account, you must also supply a password. Windows
echo does not allow a Service to be run by a user account without a password.
echo Note that this script will NOT create the user account you specify. The 
echo account must already exist.
echo.
echo You can use the CreateSmedgeUser script to create a suitable local
echo Administrator account yourself if you wish. See that script for more
echo information.
echo.
pause
set _RESULT=1
goto :cleanup


:adv_usage

echo You must set these variables before calling this script:
echo    _COMPONENT      (e.g., SmedgeEngine)
echo    _DISPLAY        (e.g., Smedge Engine)
echo    _MESSAGE        (e.g., Enable this machine to do work assigned by Smedge)
echo.
pause
set _RESULT=1
goto :cleanup


:corrupt

echo The script file cannot find the SmedgeEngine executable.
echo.
echo Ensure that this file is in the Utilities folder of the Smedge
echo installation folder, and that the SmedgeEngine.exeprogram file is in
echo the base Smedge installation folder.
echo.
echo Alternatively, supply the full path to the executable using the
echo -exe "path-to-%_COMPONENT%.exe"
echo.
pause
set _RESULT=1
goto :cleanup


:failed

echo The service failed to %_S_OP%
echo.
type %_LOG%
del %_LOG%
set _S_OP=
pause
set _RESULT=2
goto :cleanup


:exit_0

rem successful exit
set _RESULT=
exit /b 0


:exit_1

rem unsuccessful exit: operator error
set _RESULT=
exit /b 1


:exit_2

rem unsuccessful exit: failed operation
set _RESULT=
exit /b 2
