@echo off
rem CreateSmedgeUser.bat
rem
rem Creates a user account suitable for running the SmedgeEngine process
rem
rem Smedge 3
rem Copyright Uberware. All Rights Reserved


rem Save the script directory so we can find the support files

set _CSU_DIR=%~dp0
set _CSU_LOG="%TEMP%\_CreateSmedgeUser.log"


rem Determine the user account name
rem Use "Smedge" if no account name specified

if [%1]==[] (
	set _CSU_USER=Smedge
) else (
	set _CSU_USER=%1
)

rem Determine the password
rem Use "Smedge" if no password specified

if [%2]==[] (
	set _CSU_PASS=Smedge
) else (
	set _CSU_PASS=%2
)

rem Check if the user account exists already

net user %_CSU_USER% 1>nul 2>nul
if %ERRORLEVEL% == 0 goto :exists

rem Create the user account

echo ++ Creating user account "%_CSU_USER%" ++
echo.
set _CSU_OP=create the user
net user %_CSU_USER% %_CSU_PASS% /add 1>%_CSU_LOG% 2>&1
del %_CSU_LOG%

if %ERRORLEVEL% NEQ 0 goto :error

rem Make the account a system administrator
rem This is a security issue. If you need more specific security
rem control over the Smedge user account, you should create the
rem account yourself.

set _CSU_OP=make the user an Administrator
net localgroup Administrators %_CSU_USER% /add 1>%_CSU_LOG% 2>&1
if %ERRORLEVEL% NEQ 0 goto :error
del %_CSU_LOG%

rem Remove the user from the normal Users group

set _CSU_OP=remove the user from the Users group
net localgroup Users %_CSU_USER% /delete 1>%_CSU_LOG% 2>&1
if %ERRORLEVEL% NEQ 0 goto :error
del %_CSU_LOG%


rem Make sure that the new account password never expires

set _CSU_OP=ensure the password does not expire
cscript //nologo "%_CSU_DIR%nopwdexp.vbs" /domain:. /user:%_CSU_USER% 1>%_CSU_LOG% 2>&1
if %ERRORLEVEL% NEQ 0 goto :error
del %_CSU_LOG%


rem Hide the account from the login screen

SET _CSU_OP=hide the account from the login screen
regedit /s "%_CSU_DIR%HideSmedge.reg" 1>%_CSU_LOG% 2>&1
if %ERRORLEVEL% NEQ 0 goto :error
del %_CSU_LOG%
goto :exit


:exists
echo ++ User account "%_CSU_USER%" exists ++
echo.
goto :exit


:error
echo Warning: Failed to %_CSU_OP%:
type %_CSU_LOG%
del %_CSU_LOG%
pause
goto :exit


:exit

rem Cleanup!

set _CSU_OP=
set _CSU_USER=
set _CSU_PASS=
set _CSU_LOG=
set _CSU_DIR=

