-- SmedgeRender.ms
--
-- A simple submit script to send jobs to Smedge from inside the Max interface
--
-- Smedge
-- Copyright (c) 2004 - 2014 Uberware. All rights reserved.



-------------------------------------------------------------------
--                  CONFIGURATION                                --
-------------------------------------------------------------------


--
-- Update this path to the path to your Submit.exe executable
--

global smedgeSubmitPath = "S:/Smedge/PC/Submit.exe"


--
-- Update this with your list of Pools
--

global smedgePoolList = #("Whole System", "3DS Max 2011")


-------------------------------------------------------------------





-- generate data we need ahead of time
if( maxFileName == "" ) then return false;

-- remove the old window, if exists
try destroyDialog smedgeRenderRollout catch()

-- define the render dialog display
rollout smedgeRenderRollout "Smedge Render"
(
	-- Generate the UI
	group "Job Name"
	(
		edittext smedgeJobName text:(filterString maxFileName "." )[1]
	)
	group "Options"
	(
		checkbox smedgePaused "Paused" checked:false
		slider smedgePriority "Priority" range:[0,100,50] type:#integer
		dropdownlist smedgePool "Pool" items:smedgePoolList
	)
	button smedgeSubmit "Submit"
	on smedgeSubmit pressed do
	(
		-- generate the command line
		cmd = smedgeSubmitPath + " Script -Type 3D Studio Max"
		cmd += " -Name " + smedgeJobName.text
		cmd += " -Scene \"" + maxFilePath + maxFileName + "\""
		cmd += " -Range "
		if( rendTimeType == 1 ) then cmd += (filterstring (slidertime as string) "f")[ 1 ]
		if( rendTimeType == 2 ) then cmd += (filterstring (animationRange as string) "( ) f interval")[ 1 ] + " - " + (filterstring (animationRange as string) "( ) f interval")[ 2 ]
		if( rendTimeType == 3 ) then cmd += (filterstring (rendStart as string) "f")[ 1 ] + " - " + (filterstring (rendEnd as string) "f")[ 2 ]
		if( rendTimeType == 4 ) then cmd += rendPickupFrames
		cmd += " -Priority " + (smedgePriority.value as string)
		cmd += " -Pool " + smedgePool.selected
		if( smedgePaused.checked ) then cmd += " -Paused "

		-- run the command
		DOSCommand cmd
		-- close the window
		destroyDialog smedgeRenderRollout
	)
)

-- show the dialog
createDialog smedgeRenderRollout
