# smedgeRender_C4D.py
# Smedge Submitter Script for Cinema 4D
#
# Smedge
# Copyright 2004 - 2014 Uberware. All Rights Reserved.


#  Initialize
import c4d
import subprocess
import os
from c4d import documents,storage


#  Set this to the path to the Smedge executable
#       ****   NOTE   ****
#  You need to adjust this path to be correct for your system. The default path
#  below is often where Smedge is installed. On Mac, Submit is inside the app bundle:
#  /Applications/Smedge.app/Contents/MacOS/Submit
#       ******************
smedgePath = '"C:\\Program Files (x86)\\Smedge\\Submit.exe"'


#  Get the document info
fps = doc.GetFps()
scenename = doc.GetDocumentName()
scenepath = doc.GetDocumentPath()
rd = doc.GetActiveRenderData()
sf = (rd[ c4d.RDATA_FRAMEFROM ]).GetFrame( fps )
ef = (rd[ c4d.RDATA_FRAMETO ]).GetFrame( fps )

#  Get the whole filename by combining scene path and scene name
fn = os.path.join( scenepath, scenename )

#  Build the command line
sj  = str( smedgePath )
sj += " Script"
sj += " -Type Cinema 4D"
sj += " -Scene " + str( fn )
sj += " -Range " + str( sf ) + "-" + str( ef )
sj += " -Name " + str( scenename )
#  other options you may want to add (uncomment them if you want to use them):
#  this sets the packet size (how many frames are rendered by one machine at one time)
#sj += " -PacketSize 10"
#  this sets the pool. You can use pool names or IDs
#sj += " -Pool Pool Name"
#  this sets the number of cores to use for each render (by default it will use all available)
#sj += " -CPUs 4"
#  this sets the job to be submitted paused
#sj += " -Paused"


#  Time to do it!
print( sj )
subprocess.call( sj )
