#!perl
#
# ModoSliceFilename.pl
#  Robin Scher, Uberware LLC 
#  Copyright (c) 2014 Uberware, LLC. All Rights Reserved.
#
# Changes the output path and filename of all render output items in the scene, 

# Make sure we have our arguments
if( $#ARGV + 1 != 1 ) {
	lxout( "Usage: \@ModoSliceFilename.pl \"slice-name\"" );  
	die( "Missing required new path argument" );
}

use File::Basename;

my $n = lxq( "query sceneservice item.N ?" );

# Loop through the items in the scene, looking for output items
for( $i=0; $i < $n; $i++ ) {
	my $type = lxq( "query sceneservice item.type ? $i" );
	if( $type eq "renderOutput" ) {
		# Get the item ID
		$itemID = lxq( "query sceneservice item.id ? $i" );
		lxout( "Item ID:  $itemID" );

		# Select the item
		lx( "select.item $itemID" );

		# Get the original path
		my $originalPath = lxq( "item.channel renderOutput\$filename ?" );

		# If the path is empty, skip it
		if( !$originalPath ) {
			next;
		}

		# Split the path from the filename using regex
		my( $filename, $dir, $ext ) = fileparse( $originalPath, qr/\.[^.]*/ );

		# Combine the passed in path with the original filename
		my $newPath = $dir . $filename . '-' . $ARGV[ 0 ] . $ext;

		lx( "item.channel renderOutput\$filename {$newPath}" );
		lxout( " ... Set output filename: $originalPath  ->  $newPath\n" );
	}
}
